--- @meta

-- This file is autogenerated. Do not edit this file manually. Your changes will be ignored.
-- More information: https://github.com/MWSE/MWSE/tree/master/docs

--- A set of 4 floating-point numbers.
--- @class tes3vector4
--- @operator add(tes3vector4): tes3vector4
--- @operator div(number): tes3vector4
--- @operator len: number
--- @operator mul(tes3vector4): tes3vector4
--- @operator mul(number): tes3vector4
--- @operator sub(tes3vector4): tes3vector4
--- @field w number The 1st value in the vector.
--- @field x number The 2nd value in the vector.
--- @field y number The 3rd value in the vector.
--- @field z number The 4th value in the vector.
tes3vector4 = {}

--- Creates a new vector. If no parameters are provided, an empty set will be constructed.
--- @param x? number *Default*: `0`. No description yet available.
--- @param y? number *Default*: `0`. No description yet available.
--- @param z? number *Default*: `0`. No description yet available.
--- @param w? number *Default*: `0`. No description yet available.
--- @return tes3vector4 vector No description yet available.
function tes3vector4.new(x, y, z, w) end

--- Converts the vector to a string with 2 decimal places.
--- @return string result No description yet available.
function tes3vector4:__tostring() end

--- Creates a copy of the vector.
--- @return tes3vector4 result No description yet available.
function tes3vector4:copy() end

--- Calculates the distance to another vector in the standard way, i.e., using the [Euclidean distance](https://en.wikipedia.org/wiki/Euclidean_distance).
--- @param vec tes3vector4 No description yet available.
--- @return number result No description yet available.
function tes3vector4:distance(vec) end

--- Calculates the distance to another vector, using the [Chebyshev metric](https://en.wikipedia.org/wiki/Chebyshev_distance), which is defined as
--- 
--- 	math.max(math.abs(v1.x - v2.x), math.abs(v1.y - v2.y), math.abs(v1.z - v2.z), math.abs(v1.w - v2.w))
--- 
--- This is useful for ensuring that the x, y, z, and w coordinates between two vectors are all (independently) within a certain distance from each other.
--- 
--- Here is a geometric description of the difference between the normal distance and the Chebyshev distance for two `tes3vector3`s  `v1` and `v2`:
--- 
--- * If `v1:distance(v2) <= 1`, then `v2` is contained in a sphere around `v1` with radius 1 (i.e. diameter 2).
--- * If `v1:distanceChebyshev(v2) <= 1`, then `v2` is contained within a cube centered around `v1`, where the cube has length 2.
--- 
--- @param vec tes3vector4 No description yet available.
--- @return number result No description yet available.
function tes3vector4:distanceChebyshev(vec) end

--- Calculates the distance to another vector, using the [Manhattan (i.e. city block) metric](https://en.wikipedia.org/wiki/Taxicab_geometry). 
--- In the two-dimensional case, the Manhattan metric can be thought of 
--- as the distance that two taxis will have to travel if they're following a grid system.
--- The formula for the Manhattan distance is
--- 
--- 	math.abs(v1.x - v2.x) + math.abs(v1.y - v2.y) + math.abs(v1.z - v2.z) + math.abs(v1.w - v2.w)
--- 
--- This is useful for checking how far you'd actually have to move if you're only allowed to move along one axis at a time.
--- 
--- @param vec tes3vector4 No description yet available.
--- @return number result No description yet available.
function tes3vector4:distanceManhattan(vec) end

--- Calculates the length of the vector.
--- @return number result No description yet available.
function tes3vector4:length() end

--- Returns a vector containing the maximum values for each component of the given vectors.
--- @param other tes3vector4 No description yet available.
--- @return tes3vector4 result No description yet available.
function tes3vector4:max(other) end

--- Returns a vector containing the minimum values for each component of the given vectors.
--- @param other tes3vector4 No description yet available.
--- @return tes3vector4 result No description yet available.
function tes3vector4:min(other) end

